/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.service.serviceaction.utils.effectors;

import com.ibm.hwmca.fw.service.panel.GenericGui;
import com.ibm.hwmca.fw.service.statetransition.Context;
import com.ibm.hwmca.fw.service.statetransition.Effector;
import com.ibm.hwmca.fw.service.statetransition.EffectorException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.service.SD;
import java.util.Map;

public class PIPowerOnWaitOnlyVerify
implements Effector {
    private static final String TRACE_MASKT = "XRVXWO_T";
    private static final String TRACE_MASKF = "XRVXWO_F";
    private static final String TRACE_MASKD = "XRVXWO_D";
    private static final LocalizableText[] progressIndicators = new LocalizableText[]{new LocalizableText("Started"), new LocalizableText("25 percent complete"), new LocalizableText("50 percent complete"), new LocalizableText("75 percent complete"), new LocalizableText("Complete")};

    public void fire(Context context) throws EffectorException {
        Trace.trace(TRACE_MASKT, "-> PIPowerOnWaitOnlyVerify.fire");
        try {
            Map userData = context.getUserData();
            context.getVariable(SD.OVERALL_STATUS_VARIABLE).setValue(SD.CONTINUE);
            PIPowerOnWaitOnlyVerify.waitWithBusy(userData, 180, new LocalizableText("Power On Utility"));
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-! PIPowerOnWaitOnlyVerify.fire, exception caught: " + e);
            Trace.trace(TRACE_MASKT, e);
            throw new EffectorException(e);
        }
        Trace.trace(TRACE_MASKT, "<- PIPowerOnWaitOnlyVerify.fire");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void waitWithBusy(Map userData, int secsToWait, LocalizableText busyDialogHeading) {
        if (secsToWait <= 0) return;
        try {
            try {
                int waitTime = secsToWait / progressIndicators.length;
                int aii = 0;
                while (true) {
                    if (aii >= progressIndicators.length - 1) {
                        PIPowerOnWaitOnlyVerify.showBusy(userData, new LocalizableText("Power on progress:  Complete"), busyDialogHeading);
                        Thread.sleep(1000L);
                        break;
                    }
                    PIPowerOnWaitOnlyVerify.showBusy(userData, new LocalizableText("Power on in progress:  " + progressIndicators[aii].toString()), busyDialogHeading);
                    Thread.sleep(waitTime * 1000);
                    PIPowerOnWaitOnlyVerify.destroyBusy(userData);
                    ++aii;
                }
            }
            catch (InterruptedException e) {
                Object var6_7 = null;
                PIPowerOnWaitOnlyVerify.destroyBusy(userData);
                return;
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            PIPowerOnWaitOnlyVerify.destroyBusy(userData);
            throw throwable;
        }
        PIPowerOnWaitOnlyVerify.destroyBusy(userData);
    }

    private static void showBusy(Map userData, LocalizableText msg, LocalizableText heading) {
        try {
            GenericGui guiHandle = (GenericGui)userData.get("DISPLAY_HANDLE");
            guiHandle.showBusyDialog(heading, msg, userData);
        }
        catch (Exception e) {}
    }

    private static void destroyBusy(Map userData) {
        try {
            GenericGui guiHandle = (GenericGui)userData.get("DISPLAY_HANDLE");
            guiHandle.destroyBusyDialog(userData);
        }
        catch (Exception e) {}
    }
}

